<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BtsEnergyAnalysisResource\Pages;
use App\Models\BtsEnergyAnalysis;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Tables\Actions\Action;
use Illuminate\Support\Facades\Response;

class BtsEnergyAnalysisResource extends Resource
{
    protected static ?string $model = BtsEnergyAnalysis::class;
    protected static ?string $navigationIcon = 'heroicon-o-cpu-chip';
    protected static ?string $navigationLabel = 'Phân loại trạm theo lưu lượng';
    protected static ?string $modelLabel = 'Phân loại trạm theo lưu lượng';

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('file_name')
                    ->label('Tên file')
                    ->searchable(),
                Tables\Columns\TextColumn::make('file_type_label')
                    ->label('Loại file')
                    ->badge()
                    ->color(fn (BtsEnergyAnalysis $record): string => match ($record->file_type) {
                        'monthly_avg' => 'info',
                        'monthly_detail' => 'success',
                        default => 'gray',
                    }),
                Tables\Columns\TextColumn::make('status_label')
                    ->label('Trạng thái')
                    ->badge()
                    ->color(fn (BtsEnergyAnalysis $record): string => match ($record->status) {
                        'pending' => 'gray',
                        'processing' => 'warning',
                        'completed' => 'success',
                        'error' => 'danger',
                        default => 'gray',
                    }),
                // Tables\Columns\TextColumn::make('processed_count')
                //     ->label('Số bản ghi xử lý')
                //     ->numeric(),
            ])
            ->filters([
                // Tables\Filters\SelectFilter::make('file_type')
                //     ->label('Loại file')
                //     ->options([
                //         'monthly_detail' => 'Monthly Detail',
                //         'monthly_avg' => 'Monthly Average',
                //     ]),
            ])
            ->actions([
                Action::make('download')
                    ->label('Download')
                    ->icon('heroicon-o-document-arrow-down')
                    ->color('success')
                    ->url(fn (BtsEnergyAnalysis $record) => route('download.result', $record->result_file))
                    ->openUrlInNewTab()
                    ->visible(fn (BtsEnergyAnalysis $record) => $record->status === 'completed'),
            ])
            ->bulkActions([
                //
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBtsEnergyAnalyses::route('/'),
        ];
    }
}
