<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BtsPowerConsumptionResource\Pages;
use App\Filament\Resources\BtsPowerConsumptionResource\RelationManagers;
use App\Models\BtsPowerConsumption;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BtsPowerConsumptionResource extends Resource
{
    protected static ?string $model = BtsPowerConsumption::class;
    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationLabel = 'Phân loại trạm theo phần tử';
    protected static ?string $modelLabel = 'Phân loại trạm theo phần tử';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('file_name')
                    ->label('Tên file')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('file_type_label')
                    ->label('Loại file')
                    ->badge()
                    ->color(fn (BtsPowerConsumption $record): string => match ($record->file_type) {
                        'full' => 'info',
                        'no_cooling' => 'success',
                        'no_tx' => 'gray',
                        default => 'danger',
                    }),
                Tables\Columns\TextColumn::make('status_label')
                    ->label('Trạng thái')
                    ->badge()
                    ->color(fn (BtsPowerConsumption $record): string => match ($record->status) {
                        'pending' => 'gray',
                        'processing' => 'warning',
                        'completed' => 'success',
                        'error' => 'danger',
                        default => 'gray',
                    }),
                // Tables\Columns\TextColumn::make('uploaded_by')
                //     ->label('Người upload')
                //     ->formatStateUsing(fn ($state) => $state ? \App\Models\User::find($state)?->name : 'N/A'),
            ])
            ->filters([
                // Tables\Filters\SelectFilter::make('status')
                //     ->label('Trạng thái')
                //     ->options([
                //         'pending' => 'Chờ xử lý',
                //         'processing' => 'Đang xử lý',
                //         'completed' => 'Hoàn thành',
                //         'failed' => 'Lỗi',
                //     ]),
                Tables\Filters\SelectFilter::make('file_type')
                    ->label('Loại file')
                    ->options([
                        'full' => 'Trạm BTS có đủ các thành phần',
                        'no_cooling' => 'Trạm BTS không có Cooling',
                        'no_tx' => 'Trạm BTS không có TX',
                    ]),
            ])
            ->actions([
                Tables\Actions\Action::make('download')
                    ->label('Download')
                    ->icon('heroicon-o-document-arrow-down')
                    ->color('success')
                    ->visible(fn ($record) => $record->status === 'completed')
                    ->url(fn ($record) => route('bts-power.download', $record->id))
                    ->openUrlInNewTab(),
                // Tables\Actions\EditAction::make(),
                // Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBtsPowerConsumptions::route('/'),
            'create' => Pages\CreateBtsPowerConsumption::route('/create'),
            'edit' => Pages\EditBtsPowerConsumption::route('/{record}/edit'),
        ];
    }
}
