<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BtsRankingResource\Pages;
use App\Filament\Resources\BtsRankingResource\RelationManagers;
use App\Models\BtsRanking;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BtsRankingResource extends Resource
{
    protected static ?string $model = BtsRanking::class;

    protected static ?string $navigationIcon = 'heroicon-o-trophy';
    
    protected static ?string $navigationLabel = 'Phân loại MPĐ';
    
    protected static ?string $modelLabel = 'Phân loại MPĐ';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('file_name')
                    ->label('Tên file')
                    ->searchable()
                    ->sortable(),
                // Tables\Columns\TextColumn::make('file_type')
                //     ->label('Loại file')
                //     ->badge()
                //     ->color(fn (string $state): string => match ($state) {
                //         'xlsx' => 'success',
                //         'csv' => 'info',
                //         default => 'gray',
                //     }),
                Tables\Columns\TextColumn::make('status_label')
                    ->label('Trạng thái')
                    ->badge()
                    ->color(fn (BtsRanking $record): string => match ($record->status) {
                        'pending' => 'warning',
                        'processing' => 'info',
                        'completed' => 'success',
                        'failed' => 'danger',
                        default => 'gray',
                    }),
                // Tables\Columns\TextColumn::make('uploaded_by')
                //     ->label('Người upload')
                //     ->formatStateUsing(fn ($state) => $state ? \App\Models\User::find($state)?->name : 'N/A'),
            ])
            ->filters([
                // Tables\Filters\SelectFilter::make('status')
                //     ->label('Trạng thái')
                //     ->options([
                //         'pending' => 'Chờ xử lý',
                //         'processing' => 'Đang xử lý',
                //         'completed' => 'Hoàn thành',
                //         'failed' => 'Lỗi',
                //     ]),
                // Tables\Filters\SelectFilter::make('file_type')
                //     ->label('Loại file')
                //     ->options([
                //         'xlsx' => 'Excel',
                //         'csv' => 'CSV',
                //     ]),
            ])
            ->actions([
                Tables\Actions\Action::make('download')
                    ->label('Download')
                    ->icon('heroicon-o-document-arrow-down')
                    ->color('success')
                    ->visible(fn ($record) => $record->status === 'completed')
                    ->url(fn ($record) => route('bts-ranking.download', $record->id))
                    ->openUrlInNewTab(),
                // Tables\Actions\EditAction::make(),
                // Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBtsRankings::route('/'),
            'create' => Pages\CreateBtsRanking::route('/create'),
            'edit' => Pages\EditBtsRanking::route('/{record}/edit'),
        ];
    }
}
