<?php

namespace App\Helpers;

class FloatPrecisionHelper
{
    /**
     * Giữ nguyên độ chính xác của số float từ file Excel
     * Tự động phát hiện số chữ số thập phân gốc và giữ nguyên
     */
    public static function preserveFloatPrecision($value)
    {
        if (!is_numeric($value)) {
            return $value;
        }
        
        // Chuyển về string để giữ nguyên độ chính xác
        $stringValue = (string)$value;
        
        // Nếu có dấu chấm thập phân, đếm số chữ số sau dấu chấm
        if (strpos($stringValue, '.') !== false) {
            $parts = explode('.', $stringValue);
            $decimalPlaces = strlen($parts[1]);
            
            // Sử dụng sprintf với số chữ số thập phân gốc
            return sprintf("%.{$decimalPlaces}f", (float)$value);
        }
        
        return $stringValue;
    }
    
    /**
     * Giữ nguyên độ chính xác cho nhiều giá trị trong một mảng
     */
    public static function preserveArrayFloatPrecision($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                if (is_array($value)) {
                    $data[$key] = self::preserveArrayFloatPrecision($value);
                } else {
                    $data[$key] = self::preserveFloatPrecision($value);
                }
            }
        }
        
        return $data;
    }
}
