<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Bts extends Model
{
    protected $fillable = [
        'code',
    ];

    public function energyAnalysisDetails(): HasMany
    {
        return $this->hasMany(BtsEnergyAnalysisDetail::class);
    }

    public function powerConsumptionDetails(): HasMany
    {
        return $this->hasMany(BtsPowerConsumptionDetail::class);
    }

    public function rankingDetails(): HasMany
    {
        return $this->hasMany(BtsRankingDetail::class);
    }
}
