<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BtsEnergyAnalysis extends Model
{
    protected $fillable = [
        'file_name',
        'file_type',
        'analysis_role',
        'reference_analysis_id',
        'status',
        'result_file',
        'processed_count',
        'error_message',
        'uploaded_by',
    ];

    protected $casts = [
        'processed_count' => 'integer',
        'reference_analysis_id' => 'integer',
    ];

    //Map tiếng Việt cho loại file
    public const FILE_TYPE_LABELS = [
        'monthly_avg' => 'avg',
        'monthly_detail' => 'month_id',
    ];

    //Map tiếng Việt cho trạng thái
    public const STATUS_LABELS = [
        'pending' => 'Đang chờ',
        'processing' => 'Đang xử lý',
        'completed' => 'Hoàn thành',
        'error' => 'Lỗi',
    ];

    // Vai trò phân tích
    public const ANALYSIS_ROLES = [
        'reference' => 'File tham chiếu',
        'derived' => 'Tính theo tham chiếu',
    ];

    //Accessor cho loại file
    public function getFileTypeLabelAttribute(): string
    {
        return self::FILE_TYPE_LABELS[$this->file_type] ?? ucfirst($this->file_type ?? 'Không xác định');
    }

    //Accessor cho trạng thái
    public function getStatusLabelAttribute(): string
    {
        return self::STATUS_LABELS[$this->status] ?? ucfirst($this->status ?? 'Không xác định');
    }
}
