<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BtsEnergyAnalysisDetail extends Model
{
    protected $fillable = [
        'bts_energy_analysis_id',
        'bts_id',
        'month_id', 
        'traffic_2g',
        'data_2g',
        'amr_traf',
        'data_3g',
        'traffic_4g',
        'p_subscribeduser',
        'p_voicetraffic',
        'p_datatraffic',
        'e_powerconsumption_ac',
        'e_powerconsumption_tbvt',
        'e_powerconsumption_tbtd',
        'e_powerconsumption_maylanh',
        'distinct_attribute_pin_nlmt',
        'ei_user_power',
        'ei_voice_power',
        'ei_data_power',
        'ei_service_power',
        'qcut_norm_energy_class',
        'energy_class',
        'e_contributionratio_tbvt_ac',
        'e_contributionratio_tbtd_ac',
        'e_contributionratio_maylanh_ac'
    ];

    /**
     * Cast các cột số thành string để giữ nguyên độ chính xác
     */
    protected $casts = [
        'traffic_2g' => 'string',
        'data_2g' => 'string',
        'amr_traf' => 'string',
        'data_3g' => 'string',
        'traffic_4g' => 'string',
        'p_subscribeduser' => 'string',
        'p_voicetraffic' => 'string',
        'p_datatraffic' => 'string',
        'e_powerconsumption_ac' => 'string',
        'e_powerconsumption_tbvt' => 'string',
        'e_powerconsumption_tbtd' => 'string',
        'e_powerconsumption_maylanh' => 'string',
        'ei_user_power' => 'string',
        'ei_voice_power' => 'string',
        'ei_data_power' => 'string',
        'ei_service_power' => 'string',
        'qcut_norm_energy_class' => 'string',
        'e_contributionratio_tbvt_ac' => 'string',
        'e_contributionratio_tbtd_ac' => 'string',
        'e_contributionratio_maylanh_ac' => 'string',
    ];

    public function bts(): BelongsTo {
        return $this->belongsTo(Bts::class);
    }
    public function btsEnergyAnalysis(): BelongsTo {
        return $this->belongsTo(BtsEnergyAnalysis::class, 'bts_energy_analysis_id');
    }
}
