<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BtsPowerConsumption extends Model
{
    public $timestamps = false;
    
    protected $fillable = [
        'file_name',
        'file_type',
        'status',
        'description',
        'uploaded_by',
        'processed_at',
    ];

    protected $casts = [
        'processed_at' => 'datetime',
    ];

    public function uploader(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
    public const FILE_TYPE_LABELS = [
        'full' => 'Trạm BTS có đủ các thành phần',
        'no_cooling' => 'Trạm BTS không có Cooling',
        'no_tx' => 'Trạm BTS không có TX',
    ];

    //Map tiếng Việt cho trạng thái
    public const STATUS_LABELS = [
        'pending' => 'Đang chờ',
        'processing' => 'Đang xử lý',
        'completed' => 'Hoàn thành',
        'error' => 'Lỗi',
    ];

    //Accessor cho loại file
    public function getFileTypeLabelAttribute(): string
    {
        return self::FILE_TYPE_LABELS[$this->file_type] ?? ucfirst($this->file_type ?? 'Không xác định');
    }

    //Accessor cho trạng thái
    public function getStatusLabelAttribute(): string
    {
        return self::STATUS_LABELS[$this->status] ?? ucfirst($this->status ?? 'Không xác định');
    }
}
