<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BtsPowerConsumptionDetail extends Model
{
    protected $fillable = [
        'bts_power_consumption_id',
        'bts_id',
        'bts_type',
        'radio_power_consumption_max',
        'tx_power_consumption_max',
        'cooling_power_consumption_max',
        'bts_power_consumption_max',
        'radio_config_3g',
        'radio_config_4g',
        'radio_config_mimo_4g',
        'radio_type',
        'radio_model_name',
        'radio_family_id',
        'tx_type',
        'tx_brand_name',
        'tx_model_name',
        'tx_family_id',
        'cooling_brand_name',
        'cooling_family_id',
        'radio_family_type',
        'tx_family_type',
        'cooling_family_type',
        'power_consumption_class'
    ];

    public function bts(): BelongsTo {
        return $this->belongsTo(Bts::class);
    }
    public function btsPowerConsumption(): BelongsTo {
        return $this->belongsTo(BtsPowerConsumption::class, 'bts_power_consumption_id');
    }
}
