<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BtsRankingDetail extends Model
{
    protected $fillable = [
        'bts_ranking_id',
        'site_id',
        'obj_id',
        'mpd_id',
        'mpd_brand',
        'mpd_capacity',
        'fuel_used',
        'rated_capacity',
        'max_capacity',
        'consumption_rate_fullload',
        'mpd_type',
        'fuel_type',
        'usage_time',
        'consumption_rate',
        'usage_time_avg_year',
        'service_load_score',
        'mpd_class'
    ];

    public function btsRanking(): BelongsTo {
        return $this->belongsTo(BtsRanking::class, 'bts_ranking_id');
    }
}
