<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bts_energy_analyses', function (Blueprint $table) {
            $table->id();
            $table->string('file_name');
            $table->string('file_type'); // monthly_avg hoặc monthly_detail
            $table->string('status')->default('processing'); // processing, completed, error
            $table->string('result_file')->nullable();
            $table->integer('processed_count')->default(0);
            $table->text('error_message')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bts_energy_analyses');
    }
};
