<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bts_energy_analysis_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('bts_energy_analysis_id');
            $table->unsignedBigInteger('bts_id');
            $table->integer('month_id')->nullable();
            $table->float('traffic_2g')->nullable();
            $table->float('data_2g')->nullable();
            $table->float('amr_traf')->nullable();
            $table->float('data_3g')->nullable();
            $table->float('traffic_4g')->nullable();
            $table->float('p_subscribeduser')->nullable();
            $table->float('p_voicetraffic')->nullable();
            $table->float('p_datatraffic')->nullable();
            $table->float('e_powerconsumption_ac')->nullable();
            $table->float('e_powerconsumption_tbvt')->nullable();
            $table->float('e_powerconsumption_tbtd')->nullable();
            $table->float('e_powerconsumption_maylanh')->nullable();
            $table->float('distinct_attribute_pin_nlmt')->nullable();
            $table->float('ei_user_power')->nullable();
            $table->float('ei_voice_power')->nullable();
            $table->float('ei_data_power')->nullable();
            $table->float('ei_service_power')->nullable();
            $table->float('qcut_norm_energy_class')->nullable();
            $table->string('energy_class')->nullable();
            $table->float('e_contributionratio_tbvt_ac')->nullable();
            $table->float('e_contributionratio_tbtd_ac')->nullable();
            $table->float('e_contributionratio_maylanh_ac')->nullable();
            $table->integer('cluster_minibatchkmeans')->nullable();
            $table->integer('cluster_meanshift')->nullable();
            $table->integer('cluster_spectralclustering')->nullable();
            $table->integer('cluster_dbscan')->nullable();
            $table->integer('cluster_hdbscan')->nullable();
            $table->integer('cluster_optics')->nullable();
            $table->integer('cluster_birch')->nullable();
            $table->integer('cluster_gaussianmixture')->nullable();
            $table->timestamps();
            $table->foreign('bts_energy_analysis_id')->references('id')->on('bts_energy_analyses')->onDelete('cascade');
            $table->foreign('bts_id')->references('id')->on('bts')->onDelete('cascade');
        });
    }
    public function down(): void
    {
        Schema::dropIfExists('bts_energy_analysis_details');
    }
};
