<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bts_power_consumption_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('bts_power_consumption_id');
            $table->unsignedBigInteger('bts_id');
            $table->string('bts_type')->nullable();
            $table->float('radio_power_consumption_max')->nullable();
            $table->float('tx_power_consumption_max')->nullable();
            $table->float('cooling_power_consumption_max')->nullable();
            $table->string('radio_config_3g')->nullable();
            $table->string('radio_config_4g')->nullable();
            $table->string('radio_config_mimo_4g')->nullable();
            $table->string('radio_type')->nullable();
            $table->string('radio_model_name')->nullable();
            $table->integer('radio_family_id')->nullable();
            $table->string('tx_type')->nullable();
            $table->string('tx_brand_name')->nullable();
            $table->string('tx_model_name')->nullable();
            $table->integer('tx_family_id')->nullable();
            $table->string('cooling_brand_name')->nullable();
            $table->integer('cooling_family_id')->nullable();
            $table->string('radio_family_type')->nullable();
            $table->string('tx_family_type')->nullable();
            $table->string('cooling_family_type')->nullable();
            $table->string('power_consumption_class')->nullable();
            $table->timestamps();
            $table->foreign('bts_power_consumption_id')->references('id')->on('bts_power_consumptions')->onDelete('cascade');
            $table->foreign('bts_id')->references('id')->on('bts')->onDelete('cascade');
        });
    }
    public function down(): void
    {
        Schema::dropIfExists('bts_power_consumption_details');
    }
};
