<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bts_ranking_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('bts_ranking_id');
            $table->string('site_id')->nullable();
            $table->string('obj_id')->nullable();
            $table->string('mpd_id')->nullable();
            $table->string('mpd_brand')->nullable();
            $table->float('mpd_capacity')->nullable();
            $table->float('fuel_used')->nullable();
            $table->float('rated_capacity')->nullable();
            $table->float('max_capacity')->nullable();
            $table->float('consumption_rate_fullload')->nullable();
            $table->string('mpd_type')->nullable();
            $table->string('fuel_type')->nullable();
            $table->float('usage_time')->nullable();
            $table->float('consumption_rate')->nullable();
            $table->float('usage_time_avg_year')->nullable();
            $table->float('service_load_score')->nullable();
            $table->string('mpd_class')->nullable();
            $table->timestamps();
            
            $table->foreign('bts_ranking_id')->references('id')->on('bts_rankings')->onDelete('cascade');
        });
    }
    public function down(): void
    {
        Schema::dropIfExists('bts_ranking_details');
    }
};
