<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Thêm uploaded_by vào bảng bts_energy_analyses
        Schema::table('bts_energy_analyses', function (Blueprint $table) {
            $table->unsignedBigInteger('uploaded_by')->nullable()->after('error_message');
            $table->foreign('uploaded_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('bts_energy_analyses', function (Blueprint $table) {
            $table->dropForeign(['uploaded_by']);
            $table->dropColumn('uploaded_by');
        });

    }
};
