<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bts_energy_analysis_details', function (Blueprint $table) {
            // Chuyển các cột float thành string để giữ nguyên độ chính xác
            $table->string('traffic_2g', 50)->nullable()->change();
            $table->string('data_2g', 50)->nullable()->change();
            $table->string('amr_traf', 50)->nullable()->change();
            $table->string('data_3g', 50)->nullable()->change();
            $table->string('traffic_4g', 50)->nullable()->change();
            $table->string('p_subscribeduser', 50)->nullable()->change();
            $table->string('p_voicetraffic', 50)->nullable()->change();
            $table->string('p_datatraffic', 50)->nullable()->change();
            $table->string('e_powerconsumption_ac', 50)->nullable()->change();
            $table->string('e_powerconsumption_tbvt', 50)->nullable()->change();
            $table->string('e_powerconsumption_tbtd', 50)->nullable()->change();
            $table->string('e_powerconsumption_maylanh', 50)->nullable()->change();
            $table->string('ei_user_power', 50)->nullable()->change();
            $table->string('ei_voice_power', 50)->nullable()->change();
            $table->string('ei_data_power', 50)->nullable()->change();
            $table->string('ei_service_power', 50)->nullable()->change();
            $table->string('qcut_norm_energy_class', 50)->nullable()->change();
            $table->string('e_contributionratio_tbvt_ac', 50)->nullable()->change();
            $table->string('e_contributionratio_tbtd_ac', 50)->nullable()->change();
            $table->string('e_contributionratio_maylanh_ac', 50)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bts_energy_analysis_details', function (Blueprint $table) {
            // Revert về float
            $table->float('traffic_2g')->nullable()->change();
            $table->float('data_2g')->nullable()->change();
            $table->float('amr_traf')->nullable()->change();
            $table->float('data_3g')->nullable()->change();
            $table->float('traffic_4g')->nullable()->change();
            $table->float('p_subscribeduser')->nullable()->change();
            $table->float('p_voicetraffic')->nullable()->change();
            $table->float('p_datatraffic')->nullable()->change();
            $table->float('e_powerconsumption_ac')->nullable()->change();
            $table->float('e_powerconsumption_tbvt')->nullable()->change();
            $table->float('e_powerconsumption_tbtd')->nullable()->change();
            $table->float('e_powerconsumption_maylanh')->nullable()->change();
            $table->float('ei_user_power')->nullable()->change();
            $table->float('ei_voice_power')->nullable()->change();
            $table->float('ei_data_power')->nullable()->change();
            $table->float('ei_service_power')->nullable()->change();
            $table->float('qcut_norm_energy_class')->nullable()->change();
            $table->float('e_contributionratio_tbvt_ac')->nullable()->change();
            $table->float('e_contributionratio_tbtd_ac')->nullable()->change();
            $table->float('e_contributionratio_maylanh_ac')->nullable()->change();
        });
    }
};
