<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('bts_energy_analysis_details', function (Blueprint $table) {
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_minibatchkmeans')) {
                $table->dropColumn('cluster_minibatchkmeans');
            }
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_meanshift')) {
                $table->dropColumn('cluster_meanshift');
            }
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_spectralclustering')) {
                $table->dropColumn('cluster_spectralclustering');
            }
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_dbscan')) {
                $table->dropColumn('cluster_dbscan');
            }
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_hdbscan')) {
                $table->dropColumn('cluster_hdbscan');
            }
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_optics')) {
                $table->dropColumn('cluster_optics');
            }
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_birch')) {
                $table->dropColumn('cluster_birch');
            }
            if (Schema::hasColumn('bts_energy_analysis_details', 'cluster_gaussianmixture')) {
                $table->dropColumn('cluster_gaussianmixture');
            }
        });
    }

    public function down(): void
    {
        Schema::table('bts_energy_analysis_details', function (Blueprint $table) {
            $table->integer('cluster_minibatchkmeans')->nullable();
            $table->integer('cluster_meanshift')->nullable();
            $table->integer('cluster_spectralclustering')->nullable();
            $table->integer('cluster_dbscan')->nullable();
            $table->integer('cluster_hdbscan')->nullable();
            $table->integer('cluster_optics')->nullable();
            $table->integer('cluster_birch')->nullable();
            $table->integer('cluster_gaussianmixture')->nullable();
        });
    }
};


