<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('bts_energy_analyses', function (Blueprint $table) {
            $table->string('analysis_role')->default('reference')->after('file_type'); // reference|derived
            $table->unsignedBigInteger('reference_analysis_id')->nullable()->after('analysis_role');
            $table->foreign('reference_analysis_id')->references('id')->on('bts_energy_analyses')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('bts_energy_analyses', function (Blueprint $table) {
            $table->dropForeign(['reference_analysis_id']);
            $table->dropColumn(['analysis_role', 'reference_analysis_id']);
        });
    }
};


