<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class UpdateCoolingPowerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $fileA = storage_path('app/max-power/type3.xlsx'); // file A
        $fileB = storage_path('app/max-power/Cooling_power_max.xlsx'); // file B

        // 1. Đọc file B và tính tổng Cooling_power_consumption_max theo BTS_id
        $spreadsheetB = IOFactory::load($fileB);
        $sheetB = $spreadsheetB->getActiveSheet();
        $dataB = $sheetB->toArray();
        $headerB = $dataB[0];

        $btsIdIndexB = array_search('BTS_id', $headerB);
        $coolingPowerIndexB = array_search('Cooling_power_consumption_max', $headerB);

        $btsCoolingPower = [];

        foreach (array_slice($dataB, 1) as $row) {
            $bts_id = $row[$btsIdIndexB];
            $powerRaw = $row[$coolingPowerIndexB];

            // Lấy số thực, bỏ ký tự phía sau
            if (is_numeric($powerRaw)) {
                $power = (float)$powerRaw;
            } else {
                if (preg_match('/[\d\.]+/', $powerRaw, $matches)) {
                    $power = (float)$matches[0];
                } else {
                    $power = 0;
                }
            }

            if (!isset($btsCoolingPower[$bts_id])) {
                $btsCoolingPower[$bts_id] = 0;
            }

            $btsCoolingPower[$bts_id] += $power; // sum số thực, giữ thập phân
        }

        // 2. Đọc file A và cập nhật cột Cooling_power_consumption_max theo BTS_id
        $spreadsheetA = IOFactory::load($fileA);
        $sheetA = $spreadsheetA->getActiveSheet();
        $dataA = $sheetA->toArray();
        $headerA = $dataA[0];

        $btsIdIndexA = array_search('BTS_id', $headerA);
        $coolingPowerIndexA = array_search('Cooling_power_consumption_max', $headerA);

        // Nếu chưa có cột Cooling_power_consumption_max trong A, thêm cột cuối
        if ($coolingPowerIndexA === false) {
            $coolingPowerIndexA = count($headerA);
            $columnLetter = Coordinate::stringFromColumnIndex($coolingPowerIndexA + 1);
            $sheetA->setCellValue($columnLetter . '1', 'Cooling_power_consumption_max');
        }

        foreach (array_slice($dataA, 1) as $index => $row) {
            $bts_id = $row[$btsIdIndexA];
            if (isset($btsCoolingPower[$bts_id])) {
                $columnLetter = Coordinate::stringFromColumnIndex($coolingPowerIndexA + 1);
                $sheetA->setCellValue($columnLetter . ($index + 2), $btsCoolingPower[$bts_id]);
            }
        }

        // 3. Ghi lại file A (cập nhật trực tiếp)
        $writerA = new Xlsx($spreadsheetA);
        $writerA->save($fileA);

        $this->command->info('File all-type.xlsx đã được cập nhật Cooling_power_consumption_max trực tiếp từ file B.');
    }
}
