<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class UpdateTxPowerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $fileA = storage_path('app/max-power/type2.xlsx'); // file A
        $fileB = storage_path('app/max-power/TX_power_max.xlsx'); // file B

        // 1. Đọc file B và tính tổng MAX Power theo BTS_id
        $spreadsheetB = IOFactory::load($fileB);
        $sheetB = $spreadsheetB->getActiveSheet()->toArray();
        $headerB = $sheetB[0];

        $btsIdIndexB = array_search('Site ID', $headerB);
        $powerIndexB = array_search('MAX Power Consumption', $headerB);

        $btsPower = [];

        foreach (array_slice($sheetB, 1) as $row) {
            $bts_id = $row[$btsIdIndexB];
            $powerRaw = $row[$powerIndexB];
        
            // 1. Chỉ lấy số (cả thập phân), bỏ ký tự phía sau
            if (is_numeric($powerRaw)) {
                $power = (float)$powerRaw;
            } else {
                // Dùng regex để lấy số thập phân/ nguyên đầu tiên trong chuỗi
                if (preg_match('/[\d\.]+/', $powerRaw, $matches)) {
                    $power = (float)$matches[0];
                } else {
                    $power = 0; // nếu không tìm được số
                }
            }
        
            if (!isset($btsPower[$bts_id])) {
                $btsPower[$bts_id] = 0;
            }
        
            $btsPower[$bts_id] += $power; // sum số thực, giữ thập phân
        }
        

        // 2. Đọc file A và cập nhật TX_power_consumption_max
        $spreadsheetA = IOFactory::load($fileA);
        $sheetA = $spreadsheetA->getActiveSheet();
        $dataA = $sheetA->toArray();
        $headerA = $dataA[0];

        $btsIdIndexA = array_search('BTS_id', $headerA);
        $txPowerIndexA = array_search('TX_power_consumption_max', $headerA);

        // Bỏ header
        $rows = array_slice($dataA, 1);

        foreach ($rows as $index => $row) {
            $bts_id = $row[$btsIdIndexA];
            if (isset($btsPower[$bts_id])) {
                // Cập nhật giá trị trong spreadsheet (index + 2 vì bỏ qua header và bắt đầu từ 1)
                $columnLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($txPowerIndexA + 1);
                $sheetA->setCellValue($columnLetter . ($index + 2), $btsPower[$bts_id]);
            }
        }

        // 3. Ghi lại file A (cập nhật trực tiếp file gốc)
        $writer = new Xlsx($spreadsheetA);
        $writer->save($fileA);

        $this->command->info('File all-type.xlsx đã được cập nhật TX_power_consumption_max trực tiếp.');
    }
}
