<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Response;

Route::get('/', function () {
    return view('welcome');
});

// Route để download file kết quả
Route::get('/download-result/{filename}', function ($filename) {
    $filePath = storage_path('app/bts-analysis/results/' . $filename);
    
    if (file_exists($filePath)) {
        return Response::download($filePath);
    }
    
    abort(404, 'File không tồn tại');
})->name('download.result');

// Route để download file BTS Power Consumption
Route::get('/bts-power/download/{id}', function ($id) {
    $btsPower = \App\Models\BtsPowerConsumption::findOrFail($id);
    
    if ($btsPower->status !== 'completed') {
        abort(404, 'File chưa được xử lý xong');
    }
    
    // Tìm file đã xử lý
    $filePath = storage_path('app/private/bts-power/' . basename($btsPower->file_name));
    
    if (!file_exists($filePath)) {
        // Thử đường dẫn khác
        $filePath = storage_path('app/bts-power/' . basename($btsPower->file_name));
    }
    
    if (file_exists($filePath)) {
        return Response::download($filePath, $btsPower->file_name);
    }
    
    abort(404, 'File không tồn tại');
})->name('bts-power.download');

// Route để download file BTS Ranking
Route::get('/bts-ranking/download/{id}', function ($id) {
    $btsRanking = \App\Models\BtsRanking::findOrFail($id);
    
    if ($btsRanking->status !== 'completed') {
        abort(404, 'File chưa được xử lý xong');
    }
    
    // Tìm file đã xử lý
    $filePath = storage_path('app/private/bts-ranking/' . basename($btsRanking->file_name));
    
    if (!file_exists($filePath)) {
        // Thử đường dẫn khác
        $filePath = storage_path('app/bts-ranking/' . basename($btsRanking->file_name));
    }
    
    if (file_exists($filePath)) {
        return Response::download($filePath, $btsRanking->file_name);
    }
    
    abort(404, 'File không tồn tại');
})->name('bts-ranking.download');

