<?php

require_once 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;

// Tăng precision của PHP
ini_set('precision', 20);

// Function để giữ nguyên độ chính xác của số float
function preserveFloatPrecision($value) {
    if (!is_numeric($value)) {
        return $value;
    }
    
    // Chuyển về string để giữ nguyên độ chính xác
    $stringValue = (string)$value;
    
    // Nếu có dấu chấm thập phân, đếm số chữ số sau dấu chấm
    if (strpos($stringValue, '.') !== false) {
        $parts = explode('.', $stringValue);
        $decimalPlaces = strlen($parts[1]);
        
        // Sử dụng sprintf với số chữ số thập phân gốc
        return sprintf("%.{$decimalPlaces}f", (float)$value);
    }
    
    return $stringValue;
}

// Tạo file Excel test với số float có độ chính xác cao
$spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
$worksheet = $spreadsheet->getActiveSheet();

// Thêm headers
$worksheet->setCellValue('A1', 'STT');
$worksheet->setCellValue('B1', 'BTS_id');
$worksheet->setCellValue('C1', 'E_PowerConsumption_AC');

// Thêm dữ liệu test với số float có độ chính xác cao
$testValue = 0.335286251968129;
$testValueString = (string)$testValue; // Giữ nguyên độ chính xác gốc

echo "Giá trị gốc: {$testValue}\n";
echo "Giá trị string: {$testValueString}\n";

$worksheet->setCellValue('A2', 1);
$worksheet->setCellValue('B2', 'BTS001');
// Sử dụng setCellValueExplicit với string đã format
$worksheet->setCellValueExplicit('C2', $testValueString, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);

// Lưu file test
$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
$testFile = 'test_float_precision.xlsx';
$writer->save($testFile);

echo "Đã tạo file test: {$testFile}\n";

// Test cách đọc cũ (có thể bị làm tròn)
$spreadsheet = IOFactory::load($testFile);
$worksheet = $spreadsheet->getActiveSheet();
$oldValue = $worksheet->getCell('C2')->getValue();
echo "Cách đọc cũ: {$oldValue}\n";

// Test cách đọc mới (giữ nguyên độ chính xác) - theo code đã update
$cell = $worksheet->getCell('C2');
$value = $cell->getValue();

// Sử dụng function preserveFloatPrecision để giữ nguyên độ chính xác gốc
$newValue = preserveFloatPrecision($value);

echo "Cách đọc mới (đã update): {$newValue}\n";

// So sánh với giá trị string gốc
if ($newValue === $testValueString) {
    echo "✅ Thành công! Độ chính xác được giữ nguyên.\n";
} else {
    echo "❌ Vẫn bị làm tròn. Cần kiểm tra thêm.\n";
    echo "Expected: {$testValueString}\n";
    echo "Got: {$newValue}\n";
}

// Test thêm với một số float có nhiều chữ số thập phân
$testValue2 = 1.2345678901234567890123456789;
$testValue2String = (string)$testValue2; // Giữ nguyên độ chính xác gốc

// Tạo file test mới cho test 2
$spreadsheet2 = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
$worksheet2 = $spreadsheet2->getActiveSheet();
$worksheet2->setCellValue('A1', 'STT');
$worksheet2->setCellValue('B1', 'BTS_id');
$worksheet2->setCellValue('C1', 'E_PowerConsumption_AC');
$worksheet2->setCellValue('A2', 1);
$worksheet2->setCellValue('B2', 'BTS002');
$worksheet2->setCellValueExplicit('C2', $testValue2String, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);

$writer2 = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet2);
$testFile2 = 'test_float_precision2.xlsx';
$writer2->save($testFile2);

$spreadsheet2 = IOFactory::load($testFile2);
$worksheet2 = $spreadsheet2->getActiveSheet();
$cell2 = $worksheet2->getCell('C2');
$value2 = $cell2->getValue();
// Sử dụng function preserveFloatPrecision để giữ nguyên độ chính xác gốc
$newValue2 = preserveFloatPrecision($value2);

echo "\nTest 2:\n";
echo "Giá trị gốc: {$testValue2}\n";
echo "Giá trị string: {$testValue2String}\n";
echo "Cách đọc mới: {$newValue2}\n";

if ($newValue2 === $testValue2String) {
    echo "✅ Test 2 thành công!\n";
} else {
    echo "❌ Test 2 thất bại.\n";
    echo "Expected: {$testValue2String}\n";
    echo "Got: {$newValue2}\n";
}

// Xóa file test 2
unlink($testFile2);

// Xóa file test
unlink($testFile);
echo "\nĐã xóa file test.\n";
